//Source file: H:\middleware\src\Alkindi\BusinessServices\Util\InternalComponentManager.java

package Alkindi.Services.Util;

import Alkindi.Services.BeanIface.*;
import javax.naming.*;
import javax.rmi.PortableRemoteObject;
import Alkindi.Services.IAccountManager;
import Alkindi.Services.AlkExcept;
import Alkindi.Services.IClusterManager;
import Alkindi.Services.IRatingManager;
import Alkindi.Services.IRecommendationManager;
import Alkindi.Services.ISearchManager;

/* 
$Header: InternalComponentManager.java, 6, 5/8/01 9:54:46 AM, Schwartz, Joe$
$Log: 
 6    Alkindi Development1.5         5/8/01 9:54:46 AM    Schwartz, Joe  
      Changed to present EJB-independent method interface. Added remove()
      methods for cleaning up resources.
 5    Alkindi Development1.4         5/8/01 9:17:30 AM    Schwartz, Joe   
 4    Alkindi Development1.3         5/3/01 10:12:31 AM   Schwartz, Joe  
      Removed getAdminMgr().
 3    Alkindi Development1.2         2/12/01 4:47:45 PM   Schwartz, Joe  
      Changed to account for Product ID becoming an int.
 2    Alkindi Development1.1         12/28/00 1:07:25 PM  Schwartz, Joe   Added
      Version Control header info.
 1    Alkindi Development1.0         12/27/00 6:10:48 PM  Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * This class provides methods that allow one Component to get a reference to another. The methods are all declared as <b>static final</b> in order to speed processing. This class must be modified if the framework no longer uses EJB.
 */
public class InternalComponentManager 
{
	private static final String ACCTM_JNDI_NAME = "ejb/AcctMgrBean";
	private static final String ADM_JNDI_NAME = "ejb/AdminMgrBean";
	private static final String CM_JNDI_NAME = "ejb/ClusterMgrBean";
	private static final String cName = "InternalEJBMgr";
	private static final String RATM_JNDI_NAME = "ejb/RatingMgrBean";
	private static final String RECM_JNDI_NAME = "ejb/RecMgrBean";
	private static final String SM_JNDI_NAME = "ejb/SearchMgrBean";
	
	/**
	 * Returns a reference to an AccountManager.
	 * @return IAccountManager
	 * @throws AlkExcept
	 * @roseuid 3A410F1003A9
	 */
	public static final IAccountManager getAcctMgr() throws AlkExcept 
	{
		final String mName = "getAcctMgr";
		try {
			Context ctx = new InitialContext();
			Object obj = ctx.lookup(ACCTM_JNDI_NAME);
			IAccountManagerHome home = (IAccountManagerHome)PortableRemoteObject.narrow(obj, IAccountManagerHome.class);
			IAccountManagerBean bean = home.create();
			return bean;
		}
		catch (Exception e) {
			throw new AlkExcept("Exception in " + mName + ": " + e.getMessage(), 2731);
		}
	}
	
	/**
	 * Returns a reference to a ClusterManager.
	 * @return IClusterManager
	 * @throws AlkExcept
	 * @roseuid 3A410F170232
	 */
	public static final IClusterManager getClusterMgr() throws AlkExcept 
	{
		final String mName = "getClusterMgr";
		try {
			Context ctx = new InitialContext();
			Object obj = ctx.lookup(CM_JNDI_NAME);
			IClusterManagerHome home = (IClusterManagerHome)PortableRemoteObject.narrow(obj, IClusterManagerHome.class);
			IClusterManagerBean bean = home.create();
			return bean;
		}
		catch (Exception e) {
			throw new AlkExcept("Exception in " + mName + ": " + e.getMessage(), 2733);
		}
	}
	
	/**
	 * Returns a reference to a RatingManager.
	 * @return IRatingManager
	 * @throws AlkExcept
	 * @roseuid 3A410F1C0119
	 */
	public static final IRatingManager getRatingMgr() throws AlkExcept 
	{
		final String mName = "getRatingMgr";
		try {
			Context ctx = new InitialContext();
			Object obj = ctx.lookup(RATM_JNDI_NAME);
			IRatingManagerHome home = (IRatingManagerHome)PortableRemoteObject.narrow(obj, IRatingManagerHome.class);
			IRatingManagerBean bean = home.create();
			return bean;
		}
		catch (Exception e) {
			throw new AlkExcept("Exception in " + mName + ": " + e.getMessage(), 2734);
		}
	}
	
	/**
	 * Returns a reference to a RecommendationManager.
	 * @return IRecommendationManager
	 * @throws AlkExcept
	 * @roseuid 3A410F23008C
	 */
	public static final IRecommendationManager getRecMgr() throws AlkExcept 
	{
		final String mName = "getRecMgr";
		try {
			Context ctx = new InitialContext();
			Object obj = ctx.lookup(RECM_JNDI_NAME);
			IRecommendationManagerHome home = (IRecommendationManagerHome)PortableRemoteObject.narrow(obj, IRecommendationManagerHome.class);
			IRecommendationManagerBean bean = home.create();
			return bean;
		}
		catch(Exception e) {
			throw new AlkExcept("Exception in " + mName + ": " + e.getMessage(), 2735);
		}
	}
	
	/**
	 * Returns a reference to a SearchManager.
	 * @return ISearchManager
	 * @throws AlkExcept
	 * @roseuid 3A410F270167
	 */
	public static final ISearchManager getSearchMgr() throws AlkExcept 
	{
		final String mName = "getSearchMgr";
		try {
			Context ctx = new InitialContext();
			Object obj = ctx.lookup(SM_JNDI_NAME);
			ISearchManagerHome home = (ISearchManagerHome)PortableRemoteObject.narrow(obj, ISearchManagerHome.class);
			ISearchManagerBean bean = home.create();
			return bean;
		}
			catch (Exception e) {
			throw new AlkExcept("Exception in " + mName + e.getMessage(), 2736);
		}
	}
	
	/**
	 * Removes the reference to the AccountManager.
	 * @roseuid 3AF7F61A00DA
	 */
	public static final void remove(IAccountManager acctMgr) throws AlkExcept 
	{
		try {
			((IAccountManagerBean)acctMgr).remove();
		}
		catch(Exception e) {
			throw new AlkExcept("Exception removing AccountManager: " + e.getMessage(), 8006, e);
		}
	}
	
	/**
	 * Removes the reference to the ClusterManager.
	 * @roseuid 3AF7F6280261
	 */
	public static final void remove(IClusterManager clusterMgr) throws AlkExcept 
	{
		try {
			((IClusterManagerBean)clusterMgr).remove();
		}
		catch(Exception e) {
			throw new AlkExcept("Exception removing ClusterManager: " + e.getMessage(), 8006, e);
		}
	}
	
	/**
	 * Removes the reference to the RatingManager.
	 * @roseuid 3AF7F6390177
	 */
	public static final void remove(IRatingManager ratMgr) throws AlkExcept 
	{
		try {
			((IRatingManagerBean)ratMgr).remove();
		}
		catch(Exception e) {
			throw new AlkExcept("Exception removing RatingManager: " + e.getMessage(), 8006, e);
		}
	}
	
	/**
	 * Removes the reference to the RecommendationManager.
	 * @roseuid 3AF7F62F0203
	 */
	public static final void remove(IRecommendationManager recMgr) throws AlkExcept 
	{
		try {
			((IRecommendationManagerBean)recMgr).remove();
		}
		catch(Exception e) {
			throw new AlkExcept("Exception removing RecManager: " + e.getMessage(), 8006, e);
		}
	}
	
	/**
	 * Removes the reference to the SearchManager.
	 * @roseuid 3AF7F63E01F4
	 */
	public static final void remove(ISearchManager searchMgr) throws AlkExcept 
	{
		try {
			((ISearchManagerBean)searchMgr).remove();
		}
		catch(Exception e) {
			throw new AlkExcept("Exception removing SearchManager: " + e.getMessage(), 8006, e);
		}
	}
}
